#ifndef _MAINDLG_CPP
#define _MAINDLG_CPP
///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

#include <Windows.H>
#include <Stdio.H>
#include <Stdlib.H>
#include <CommCtrl.H>

#include "../Resources/Resource.H"

#include "../../SharedSource/NSWFL.H"
#include "../Source/Entry.H"
#include "../Source/Routines.H"
#include "../Source/Console.H"

#include "../Dialogs/MainDlg.H"
#include "../Dialogs/Splash.H"

#include "../Dialogs/TabClientDBS.H"
#include "../Dialogs/TabGeneral.H"
#include "../Dialogs/TabSecurity.H"
#include "../Dialogs/TabServer.H"
#include "../Dialogs/TabWPIndex.H"
#include "../Dialogs/CreateNewDB.H"
#include "../Dialogs/SysStats.H"

#include "../CSockSrvr/CSockSrvr.H"
#include "../../SharedClasses/Graph/Graph.H"

///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

//---------------------(Variable Declarations)
HWND MainDialog_hWnd = NULL;

///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

BOOL CALLBACK MainDialog(HWND xHandle, UINT xMessage, WPARAM wParam, LPARAM lParam)
{
    //--------------------------------------------------------------------------

    static HWND StaticFrame_hWnd = NULL;
    static HWND Connections_hWnd = NULL;
    static HWND TotalConnects_hWnd = NULL;
    static HWND Warnings_hWnd = NULL;
    static HWND Errors_hWnd = NULL;
	static HWND UsageGraph_hWnd = NULL;

	static HMENU SystemMenu = NULL;

	static int iLastWidth = 0;
	static int iLastHeight = 0;

    //--------------------------------------------------------------------------

    if(xMessage == WM_INITDIALOG)
    {
        MainDialog_hWnd = xHandle;
		gbIsMainDialogOpen = true;

        SystemMenu = GetSystemMenu(xHandle, FALSE);
        AppendMenu(SystemMenu, MF_SEPARATOR, 0, 0);
        AppendMenu(SystemMenu, MF_STRING, 1000, "About");

        SendMessage(xHandle, (UINT)WM_SETTEXT, (WPARAM)0, (LPARAM)gsTitleCaption);
        SendMessage(xHandle, WM_SETICON, TRUE, (LPARAM) LoadIcon(ghAppInstance, MAKEINTRESOURCE(IDI_MAIN)) );

        MDI.Menu_hWnd = LoadMenu(ghAppInstance, MAKEINTRESOURCE(IDR_SERVERDLGMENU));
		MDI.LogList_hWnd = GetDlgItem(xHandle, IDC_LOGLIST);
        MDI.StatusBar_hWnd = CreateStatusWindow(WS_CHILD|WS_VISIBLE, "Ready", xHandle, 1);

        SetMenu(xHandle, MDI.Menu_hWnd);

		UsageGraph_hWnd    = GetDlgItem(xHandle, IDC_USAGEGRAPH);
		StaticFrame_hWnd   = GetDlgItem(xHandle, IDC_STATICFRAME);
        Connections_hWnd   = GetDlgItem(xHandle, IDC_CONNECTIONS);
        TotalConnects_hWnd = GetDlgItem(xHandle, IDC_TOTALCONNECTS);
        Warnings_hWnd      = GetDlgItem(xHandle, IDC_WARNINGS);
        Errors_hWnd        = GetDlgItem(xHandle, IDC_ERRORS);

		RECT WindowRECT;
        GetClientRect(xHandle, &WindowRECT);
        MoveWindow(MDI.LogList_hWnd, 0, 101, WindowRECT.right, ((WindowRECT.bottom-20) - 101), TRUE);
        MoveWindow(StaticFrame_hWnd, 0, 0, WindowRECT.right, 100, TRUE);
        MoveWindow(UsageGraph_hWnd, 190, 10, (WindowRECT.right-195), 84, TRUE);

		if(gbShowSplashScreen)
		{
			DialogBox(ghAppInstance, MAKEINTRESOURCE(IDD_SPLASH), xHandle, SplashDialog);
		}

        if(gbDebugMode)
			CheckMenuItem(MDI.Menu_hWnd, ID_SPECIAL_DEBUGMODE, MF_BYCOMMAND|MF_CHECKED);
		else CheckMenuItem(MDI.Menu_hWnd, ID_SPECIAL_DEBUGMODE, MF_BYCOMMAND|MF_UNCHECKED);

        if(gServer.cbActive)
		{
			EnableMenuItem(MDI.Menu_hWnd, ID_SERVER_STOP, MF_BYCOMMAND|MF_ENABLED);
			EnableMenuItem(MDI.Menu_hWnd, ID_SERVER_START, MF_BYCOMMAND|MF_GRAYED|MF_DISABLED);
		}
		else{
			EnableMenuItem(MDI.Menu_hWnd, ID_SERVER_STOP, MF_BYCOMMAND|MF_GRAYED|MF_DISABLED);
			EnableMenuItem(MDI.Menu_hWnd, ID_SERVER_START, MF_BYCOMMAND|MF_ENABLED);
		}

		Set_Long(Connections_hWnd, gServer.GetCurrentClients());
        Set_Long(TotalConnects_hWnd, giTotalConnects);
        Set_Long(Warnings_hWnd, giWarningCount);
        Set_Long(Errors_hWnd, giErrorCount);

		SetTimer(xHandle, 0, 100, NULL);

		InitGraph(UsageGraph_hWnd, RGB(0,255,0), RGB(0,100,0), 2, 1);

		CenterWindow(xHandle);

		return TRUE; // Return TRUE to set the keyboard focus, Otherwise return FALSE
    }

    //--------------------------------------------------------------------------

    if(xMessage == WM_COMMAND)
    {
		if(wParam == ID_SERVER_SYSTEMSTATISTICS)
        {
			DialogBox(ghAppInstance, MAKEINTRESOURCE(IDD_SYSSTATS), xHandle, SysStatsDialog);
            return TRUE;
        }

		if(wParam == ID_REPLICATION_SETUPNEWDATABASE)
        {
			DialogBox(ghAppInstance, MAKEINTRESOURCE(IDD_CREATENEWDB), xHandle, CreateNewDBDialog);
            return TRUE;
        }

		if(wParam == ID_SPECIAL_OPENCONSOLE)
        {
            if(gbConsoleOpen)
                CloseConsole();
            else OpenConsole();
            return TRUE;
        }

        if(wParam == ID_HELP_ABOUT)
        {
            _AboutDialogInfo ADI;
    
            ADI.DisplayIcon  = LoadIcon(ghAppInstance, MAKEINTRESOURCE(IDI_MAIN));
            ADI.TitleCaption = gsTitleCaption;
            ADI.FileVersion  = gsFileVersion;
            ADI.BuildDate    = __DATE__;
            ADI.BuildTime    = __TIME__;
            ADI.CopyRight    = gsAppCopyRight;
            ADI.OwnerHandle  = xHandle;

            NetLogo(&ADI);
            return true;
        }

        if(wParam == ID_SPECIAL_DEBUGMODE)
        {
            if(gbDebugMode)
            {
                CheckMenuItem(MDI.Menu_hWnd, ID_SPECIAL_DEBUGMODE, MF_BYCOMMAND|MF_UNCHECKED);
                gbDebugMode = false;
            }
            else{
                CheckMenuItem(MDI.Menu_hWnd, ID_SPECIAL_DEBUGMODE, MF_BYCOMMAND|MF_CHECKED);
                gbDebugMode = true;
            }
            return TRUE;
        }

        if(wParam == ID_SERVER_START)
        {
            StartServer();
			if(gServer.cbActive)
			{
				EnableMenuItem(MDI.Menu_hWnd, ID_SERVER_STOP, MF_BYCOMMAND|MF_ENABLED);
				EnableMenuItem(MDI.Menu_hWnd, ID_SERVER_START, MF_BYCOMMAND|MF_GRAYED|MF_DISABLED);
			}
			else{
				EnableMenuItem(MDI.Menu_hWnd, ID_SERVER_STOP, MF_BYCOMMAND|MF_GRAYED|MF_DISABLED);
				EnableMenuItem(MDI.Menu_hWnd, ID_SERVER_START, MF_BYCOMMAND|MF_ENABLED);
			}
            return TRUE;
        }

        if(wParam == ID_SERVER_STOP)
        {
            StopServer();
			if(gServer.cbActive)
			{
				EnableMenuItem(MDI.Menu_hWnd, ID_SERVER_STOP, MF_BYCOMMAND|MF_ENABLED);
				EnableMenuItem(MDI.Menu_hWnd, ID_SERVER_START, MF_BYCOMMAND|MF_GRAYED|MF_DISABLED);
			}
			else{
				EnableMenuItem(MDI.Menu_hWnd, ID_SERVER_STOP, MF_BYCOMMAND|MF_GRAYED|MF_DISABLED);
				EnableMenuItem(MDI.Menu_hWnd, ID_SERVER_START, MF_BYCOMMAND|MF_ENABLED);
			}
            return TRUE;
        }

		if(wParam == ID_SERVER_CLOSE)
        {
            gbIsMainDialogOpen = false;
			KillTimer(xHandle, 0);
			CloseGraph(UsageGraph_hWnd);
            EndDialog(xHandle,0);
            return TRUE;
        }

        if(wParam == ID_SERVER_SETTINGS)
        {
            PROPSHEETPAGE   psp[5];
            PROPSHEETHEADER psh;

            memset(&psp[0], '\0', sizeof(PROPSHEETPAGE));
            psp[0].dwSize      = sizeof(PROPSHEETPAGE);
            psp[0].dwFlags     = PSP_DEFAULT|PSP_USETITLE;
            psp[0].hInstance   = ghAppInstance;
            psp[0].pszTemplate = MAKEINTRESOURCE(IDD_GENERALTAB);
            psp[0].pszIcon     = NULL;
            psp[0].pszTitle    = "General";
            psp[0].pfnDlgProc  = TabGeneralDialog;
            psp[0].lParam      = 0;
            psp[0].pfnCallback = NULL;
            psp[0].pcRefParent = NULL;

            memset(&psp[1], '\0', sizeof(PROPSHEETPAGE));
            psp[1].dwSize      = sizeof(PROPSHEETPAGE);
            psp[1].dwFlags     = PSP_DEFAULT|PSP_USETITLE;
            psp[1].hInstance   = ghAppInstance;
            psp[1].pszTemplate = MAKEINTRESOURCE(IDD_SECURITYTAB);
            psp[1].pszIcon     = NULL;
            psp[1].pszTitle    = "Security";
            psp[1].pfnDlgProc  = TabSecurityDialog;
            psp[1].lParam      = 0;
            psp[1].pfnCallback = NULL;
            psp[1].pcRefParent = NULL;

            memset(&psp[2], '\0', sizeof(PROPSHEETPAGE));
            psp[2].dwSize      = sizeof(PROPSHEETPAGE);
            psp[2].dwFlags     = PSP_DEFAULT|PSP_USETITLE;
            psp[2].hInstance   = ghAppInstance;
            psp[2].pszTemplate = MAKEINTRESOURCE(IDD_SERVERTAB);
            psp[2].pszIcon     = NULL;
            psp[2].pszTitle    = "Server";
            psp[2].pfnDlgProc  = TabServerDialog;
            psp[2].lParam      = 0;
            psp[2].pfnCallback = NULL;
            psp[2].pcRefParent = NULL;

            memset(&psp[3], '\0', sizeof(PROPSHEETPAGE));
            psp[3].dwSize      = sizeof(PROPSHEETPAGE);
            psp[3].dwFlags     = PSP_DEFAULT|PSP_USETITLE;
            psp[3].hInstance   = ghAppInstance;
            psp[3].pszTemplate = MAKEINTRESOURCE(IDD_WPINDEXDBTAB);
            psp[3].pszIcon     = NULL;
            psp[3].pszTitle    = "WPIndex DB";
            psp[3].pfnDlgProc  = TabWPIndexDialog;
            psp[3].lParam      = 0;
            psp[3].pfnCallback = NULL;
            psp[3].pcRefParent = NULL;

            memset(&psp[4], '\0', sizeof(PROPSHEETPAGE));
            psp[4].dwSize      = sizeof(PROPSHEETPAGE);
            psp[4].dwFlags     = PSP_DEFAULT|PSP_USETITLE;
            psp[4].hInstance   = ghAppInstance;
            psp[4].pszTemplate = MAKEINTRESOURCE(IDD_CLIENTDBSTAB);
            psp[4].pszIcon     = NULL;
            psp[4].pszTitle    = "Client DBS";
            psp[4].pfnDlgProc  = TabClientDBSDialog;
            psp[4].lParam      = 0;
            psp[4].pfnCallback = NULL;
            psp[4].pcRefParent = NULL;

            memset(&psh, '\0', sizeof(PROPSHEETHEADER));
            psh.dwSize      = sizeof(PROPSHEETHEADER);
            psh.dwFlags     = PSH_USEHICON | PSH_PROPSHEETPAGE | PSH_NOAPPLYNOW;
            psh.hwndParent  = xHandle;
            psh.hInstance   = ghAppInstance;
            psh.hIcon       = LoadIcon(ghAppInstance, MAKEINTRESOURCE(IDI_TRAYICON));
            psh.pszCaption  = "Server Settings";
            psh.nPages      = 5;
            psh.nStartPage  = 0;
            psh.ppsp        = (LPCPROPSHEETPAGE) &psp;
            psh.pfnCallback = NULL;

            PropertySheet(&psh);

			SaveRegistryValues();

            return TRUE;
        }

        return FALSE;
    }

	//--------------------------------------------------------------------------

	if(xMessage == WM_TIMER)
    {
		int iConnects = gServer.GetCurrentClients();

		Set_Long(Connections_hWnd, iConnects);
        Set_Long(TotalConnects_hWnd, giTotalConnects);
        Set_Long(Warnings_hWnd, giWarningCount);
        Set_Long(Errors_hWnd, giErrorCount);

		UpdateGraph(UsageGraph_hWnd, iConnects, giMaxClients);

		DrawGraph(UsageGraph_hWnd, RGB(0,0,0));

		return true;
    }

	//--------------------------------------------------------------------------

	if(xMessage == WM_SIZE)
    {
		if(wParam != SIZE_MAXHIDE && wParam != SIZE_MAXSHOW && wParam != SIZE_MINIMIZED)
		{
			int nWidth = LOWORD(lParam);
			int nHeight = HIWORD(lParam);

			if(iLastWidth != nWidth || iLastHeight != nHeight)
			{
				if(nWidth < 300)
					nWidth = iLastWidth;

				if(nHeight < 150)
					nHeight = iLastHeight;

				iLastWidth = nWidth;
				iLastHeight = nHeight;

				CloseGraph(UsageGraph_hWnd);

				MoveWindow(MDI.LogList_hWnd, 0, 101, nWidth, (nHeight-20) - 101, TRUE);
				MoveWindow(MDI.StatusBar_hWnd, nWidth-20, nHeight-20, nWidth, nHeight, TRUE);
				MoveWindow(StaticFrame_hWnd, 0, 0, nWidth, 100, TRUE);
				MoveWindow(UsageGraph_hWnd, 190, 10, nWidth-195, 84, TRUE);

				InitGraph(UsageGraph_hWnd, RGB(0,255,0), RGB(0,100,0), 2, 1);
				//UpdateGraph(UsageGraph_hWnd, 10, giMaxClients);
			}
		}
		return FALSE;//Return false of we process WM_SIZE.
    }

	//--------------------------------------------------------------------------

	if(xMessage == WM_PAINT)
    {
        HDC ThisHDC;
        PAINTSTRUCT ThisPS;

        ThisHDC = BeginPaint(xHandle, &ThisPS);

        // Any painting should be done here

        EndPaint(xHandle, &ThisPS);
        return TRUE;
    }

    //--------------------------------------------------------------------------

    if(xMessage == WM_SYSCOMMAND) // Received A System Menu Message
    {
        if(LOWORD(wParam) == 1000) //- About (SysMenu Command)
        {
            _AboutDialogInfo ADI;
    
            ADI.DisplayIcon  = LoadIcon(ghAppInstance, MAKEINTRESOURCE(IDI_MAIN));
            ADI.TitleCaption = gsTitleCaption;
            ADI.FileVersion  = gsFileVersion;
            ADI.BuildDate    = __DATE__;
            ADI.BuildTime    = __TIME__;
            ADI.CopyRight    = gsAppCopyRight;
            ADI.OwnerHandle  = xHandle;

            NetLogo(&ADI);
            return TRUE;
        }

        return FALSE;
    }

    //--------------------------------------------------------------------------

    if(xMessage == WM_CLOSE)  // Received Close Message
    {
        gbIsMainDialogOpen = false;
	    KillTimer(xHandle, 0);
		CloseGraph(UsageGraph_hWnd);
		EndDialog(xHandle,0);
        return TRUE;
    }

    //--------------------------------------------------------------------------

    return FALSE;
}

///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
#endif
